<?php
function verifyTelegramWebApp($bot_token, $init_data) {
    if (empty($init_data)) return ['ok' => false, 'message' => 'Init data is empty'];
    parse_str($init_data, $data);
    if (!isset($data['hash'])) return ['ok' => false, 'message' => 'Hash not found in init data'];
    $hash = $data['hash'];
    unset($data['hash']);
    ksort($data);
    $data_check_string = implode("\n", array_map(fn($k, $v) => "$k=$v", array_keys($data), array_values($data)));
    $secret_key = hash_hmac('sha256', $bot_token, 'WebAppData', true);
    $calculated_hash = bin2hex(hash_hmac('sha256', $data_check_string, $secret_key, true));
    if (isset($data['user']) && is_string($data['user'])) {
        $decoded_user = json_decode($data['user'], true);
        if (json_last_error() === JSON_ERROR_NONE) $data['user'] = $decoded_user;
        else return ['ok' => false, 'message' => 'Invalid user data format: ' . json_last_error_msg()];
    }
    if (!hash_equals($hash, $calculated_hash)) {
        return ['ok' => false, 'message' => 'Hash verification failed. Expected: ' . $calculated_hash . ', Received: ' . $hash];
    }
    return ['ok' => true, 'data' => $data];
}
?>